/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.legacy.createEntry;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.client.screen.basic.AbstractShopScreen;
import net.sixik.sdmshoprework.client.screen.basic.createEntry.AbstractCreateEntryButton;
import net.sixik.sdmshoprework.client.screen.basic.createEntry.AbstractCreateEntryScreen;
import net.sixik.sdmshoprework.client.screen.legacy.createEntry.LegacyCreateEntryButton;
import net.sixik.sdmshoprework.client.screen.legacy.createEntry.LegacyCreateEntryPanel;

public class LegacyCreateEntryScreen
extends AbstractCreateEntryScreen {
    public boolean drawDefaultBackground(PoseStack graphics) {
        return false;
    }

    public LegacyCreateEntryScreen(AbstractShopScreen shopScreen) {
        super(shopScreen);
    }

    public void addWidgets() {
        this.setWidth(this.getScreen().m_85445_() * 4 / 5);
        this.setHeight(this.getScreen().m_85446_() * 4 / 5);
        this.entriesPanel = new LegacyCreateEntryPanel((Panel)this);
        this.add((Widget)this.entriesPanel);
        this.entriesScrollPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.entriesPanel){

            public void drawScrollBar(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getShadow().draw(graphics, x + 1, y + 1, w - 2, h - 2);
                GuiHelper.drawHollowRect((PoseStack)graphics, (int)x, (int)y, (int)w, (int)h, (Color4I)SDMShopClient.getTheme().getReact(), (boolean)false);
            }

            public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                SDMShopClient.getTheme().getStoke().draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.entriesScrollPanel);
        this.backToShopButton = new AbstractCreateEntryScreen.AbstractBackButton((Panel)this);
        this.add((Widget)this.backToShopButton);
        this.shopOnlyLoadedButton = new AbstractCreateEntryScreen.AbstractShowOnlyLoadedButton((Panel)this);
        this.add((Widget)this.shopOnlyLoadedButton);
        this.closeContextMenu();
        this.setProperties();
    }

    public void alignWidgets() {
        this.setProperties();
    }

    @Override
    public void setProperties() {
        this.entriesPanel.setSize(this.width - this.width / 6, this.height - this.height / 9);
        this.entriesScrollPanel.setPosAndSize(this.entriesPanel.posX + this.entriesPanel.width - this.getScrollbarWidth(), this.entriesPanel.posY, this.getScrollbarWidth(), this.entriesPanel.height);
        Theme theme = new Theme();
        this.backToShopButton.setPosAndSize(8, this.height - 24, 60, 16);
        this.shopOnlyLoadedButton.setPosAndSize(this.backToShopButton.posX + this.backToShopButton.width + 4, this.backToShopButton.posY, 20 + theme.getStringWidth(I18n.m_118938_((String)"sdm.shop.entry.creator.info", (Object[])new Object[0])) + 5, 16);
        this.addEntriesButtons();
    }

    @Override
    public void addEntriesButtons() {
        ArrayList<AbstractCreateEntryButton> widgetList = new ArrayList<AbstractCreateEntryButton>();
        for (IConstructor<AbstractShopEntryType> value : ShopContentRegister.SHOP_ENTRY_TYPES.values()) {
            AbstractShopEntryType shopEntryType = value.createDefaultInstance();
            LegacyCreateEntryButton button = new LegacyCreateEntryButton(this.entriesPanel, shopEntryType);
            button.setSize(50, 50);
            if ((!this.showNotLoadedContent || button.isActive()) && !button.isActive()) continue;
            widgetList.add(button);
        }
        this.calculatePositions(widgetList);
        this.entriesPanel.widgets.clear();
        this.entriesPanel.addAll(widgetList);
        this.entriesScrollPanel.setValue(0.0);
    }

    public void calculatePositions(List<AbstractCreateEntryButton> entryButtons) {
        int maxElementsOnScreen = this.getCountInArray();
        int x = this.getStartPosX(this.getCountInArray());
        int y = 2;
        for (int i = 0; i < entryButtons.size(); ++i) {
            AbstractCreateEntryButton shopEntryButton = entryButtons.get(i);
            if (i > 0) {
                if (i % maxElementsOnScreen == 0) {
                    y += 56;
                    x = this.getStartPosX(this.getCountInArray());
                } else {
                    x += 53;
                }
                shopEntryButton.setPos(x, y);
                continue;
            }
            shopEntryButton.setPos(x, y);
        }
    }

    public int getCountInArray() {
        int x1 = 0;
        int x = 50;
        for (int i = 0; i < 1000; ++i) {
            x1 = x * i + 3 * i;
            if (x1 <= this.entriesPanel.width) continue;
            return i - 1;
        }
        return 0;
    }

    public int getStartPosX(int count) {
        int x = 50;
        int x1 = 0;
        for (int i = 0; i < count + 1; ++i) {
            x1 = x * i + 3 * i;
        }
        return this.entriesPanel.width / 2 - x1 / 2 + 1;
    }

    public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        SDMShopClient.getTheme().draw(graphics, x, y, w, h);
    }

    protected int getScrollbarWidth() {
        return 4;
    }
}

